***********************************************************************
*
* darts uwindow.asm -- Version 3.0 
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements  
* windows in the program.
*
***********************************************************************

               case on

               copy 2/ainclude/e16.types
               copy 2/ainclude/e16.control
               copy 2/ainclude/e16.list
               copy 2/ainclude/e16.resources
               copy darts.equ

               mcopy macros/uwindow.macros

               longi on
               longa on

***********************************************************************
*
* invalScore
*
* Invalidates a rectangle that holds the score for player one or two
* so that it will be updated.
*
invalScore     start

               DefineStack

tempHndl       long                     ;Must be at 1,s
wptr           long

saveDPage      word
returnAddr     word

playerNum      word

******************

               phd                      ;Save directPage register.
               pha                      ;Make space for locals.
               pha
               pha
               pha
               tsc                      ;Set directPage register.
               tcd

               PushLong theWindow       ;Result space is normally needed
               ldx #6                   ;for this call.  The result will be
               lda playerNum            ;placed in the local variable tempHndl.
               bne aa
               dex
aa             phx
               pea 0
               _GetCtlHandleFromID      ;Result is in tempHndl.

               pha
               pha
               _GetPort
               pla
               sta wptr
               pla
               sta wptr+2
               PushLong theWindow
               _SetPort

               ldy #2                   ;Dereference tempHndl and add offset
               lda [tempHndl],y         ;to ctlRect
               tax
               lda [tempHndl]
               clc
               adc #octlRect
               bcc ab
               inx
ab             phx                      ;Pointer to rect to invalidate.
               pha
               _InvalRect

               pei wptr+2
               pei wptr
               _SetPort

               pla                      ;Remove local variable space.
               pla
               pla
               pla
               pld                      ;Restore directPage register.
               plx                      ;Save return address.
               pla                      ;Remove passed parameters.
               phx                      ;Restore return address and return.
               rts

               end

***********************************************************************
*
* int2pstr
*
* Converts an integer into a decimal ascii string, left justified.
* The string that this function is passed must be at least 7 bytes long.
*
int2pstr       start

               DefineStack

saveDPage      word
returnAddr     word

str            long
val            word

******************

               phd                      ;Save directPage register.
               tsc                      ;Set directPage register.
               tcd

               pei val
               lda str
               ldx str+2
               inc a
               bne aa
               inx
aa             phx
               pha
               pea 6
               pea 0
               _Int2Dec                 ;It is now in the string, right justified.

               shortm                   ;Left justify it.
               ldx #6
outerLoop      ldy #1
               lda [str],y
               cmp #32
               bne leftShifted
               dex
innerLoop      iny
               lda [str],y
               dey
               sta [str],y
               iny
               cpy #6
               bcc innerLoop
               bra outerLoop

leftShifted    txa                      ;Here's how long it really is.
               sta [str]
               longm

               pld                      ;Restore directPage register.
               plx                      ;Save return address.
               pla                      ;Remove passed parameters.
               pla
               pla
               phx                      ;Restore return address and return.
               rts

               end

***********************************************************************
*
* drawThisWindow -- called by the tools (jsl)
*
* Draws the window whose port is the current port.
*
drawThisWindow start

               DefineStack

tempRect       block 8

sizeLocals     EndLocals

saveDPage      word
saveDBank      byte
returnAddr     block 3

******************

               phb                      ;We are called from the tools.
               phk                      ;The dataBank may be wrong.
               plb

               phd                      ;Save directPage register.
               tsc                      ;Make space for locals.
               sec
               sbc #sizeLocals
               tcs
               tcd                      ;Set directPage register.

               lda #1
               sta firstUpdateComplete
               lda gameType
               bne eitherGame

               tsc
               clc
               adc #tempRect            ;Where is this guy, anyway?
               pea 0|-16                ;This one is for the PaintRect.
               pha
               pea 0|-16                ;This one is for the GetPortRect
               pha
               _GetPortRect

               lda tempRect+oh2         ;Dividing line for Robin game.
               sec
               sbc tempRect+oh1
               lsr a
               sta tempRect+oh1
               inc a
               inc a
               sta tempRect+oh2
               lda tempRect+ov1
               clc
               adc #15
               sta tempRect+ov1
               lda tempRect+ov2
               sbc #18-1                ;Carry clear
               sta tempRect+ov2
               _PaintRect               ;Stack is normal again.

eitherGame     ldy #2
loop           phy                      ;Keep index
               lda score,y
               pha                      ;Value to convert to string
               tya
               asl a
               asl a                    ;*4, gives 8 or 0.
               adc 3,s                  ;Add index, result is 10 or 0.
               adc #scoreStrings
               tax
               lda #scoreStrings|-16
               adc #0
               pha                      ;String pointer.
               phx
               jsr int2pstr
               ply
               dey
               dey
               bpl loop

               PushLong #scoreStringArray
               _SetCtlParamPtr

               PushLong theWindow
               _DrawControls

               tsc                      ;Remove local variable space.
               clc
               adc #sizeLocals
               tcs
               pld                      ;Restore directPage register.
               plb                      ;Restore dataBank register.
               rtl

               end

***********************************************************************
*
* drawListItem -- called by the tools (jsl)
*
* Draws the indicated list item.  
*
drawListItem   start

               DefineStack

theScore       word
mode           word
str            block 10

sizeLocals     EndLocals

saveDPage      word
saveDBank      byte
returnAddr     block 3

theListControl long
myMemRecPtr    long
rptr           long

******************

               phb                      ;We are called from the tools.
               phk                      ;The dataBank may be wrong.
               plb

               phd                      ;Save directPage register.
               tsc                      ;Make space for locals.
               sec
               sbc #sizeLocals
               tcs
               tcd                      ;Set directPage register.

               pha                      ;Remember mode, so we can switch.
               _GetPenMode
               pla
               sta mode

               ldy #omemPtr
               lda [myMemRecPtr],y
               sta theScore             ;Score saved in lo-word of memRec ptr.

               ldy #omemFlag
               lda [myMemRecPtr],y
               and #$C0
               cmp #$80
               beq selected
               pea $8000                ;Not selected pen mode.
               _SetPenMode

selected       pei rptr+2
               pei rptr
               _PaintRect               ;Normal or inverse rectangle.

               pei mode
               _SetPenMode

               tsc
               clc
               adc #str
               pei theScore
               pea 0|-16                ;Pointer to str
               pha
               jsr int2pstr

               ldy #oh1
               lda [rptr],y
               clc
               adc #4
               pha
               iny
               iny
               lda [rptr],y
               dec a
               pha
               _MoveTo

               pha
               _GetTextMode
               pla
               sta mode

               pea $8002                ;Eor text mode, so works with selection.
               _SetTextMode

               tsc
               clc
               adc #str
               pea 0|-16
               pha
               _DrawString              ;Finally.

               pei mode
               _SetTextMode

               tsc                      ;Remove local variable space.
               clc
               adc #sizeLocals
               tcs
               pld                      ;Restore directPage register.
               ply                      ;Keep dataBank and return address.
               plx
               tsc                      ;Remove passed parameters.
               clc
               adc #12
               tcs
               phx                      ;Put dataBank and return address
               phy                      ;back on the stack.
               plb
               rtl

               end

***********************************************************************
*
* addToList
*
* Adds the indicated score to the right list.  
*
addToList      start

               DefineStack

theHndl        long                     ;Must be at 1,s
topOfList      word
numEntries     word
memRecPtr      long
size           word
listHndl       long
listPtr        long
temp           word

sizeLocals     EndLocals

saveDPage      word
returnAddr     word

amount         word
playerNum      word

******************

               phd                      ;Save directPage register.
               tsc
               sec
               sbc #sizeLocals
               tcs
               tcd                      ;Set directPage register.

               lda playerNum
               asl a
               tax
               inc listEntries,x
               lda listEntries,x
               sta numEntries           ;How many we will have after this one.
               sec
               sbc #3
               bmi aa
               bne ab
aa             lda #1
ab             sta topOfList

               lda numEntries           ;size = numEntries * 6
               asl a
               adc numEntries
               asl a
               sta size

               pha                      ;Result space.
               pha
               lda playerNum
               asl a
               asl a
               tay
               lda scoreList+2,y
               sta listHndl+2
               pha
               lda scoreList,y
               sta listHndl
               pha
               _GetHandleSize
               pla
               plx
               cmp size
               bcs bigEnough            ;List handle is big enough still.

               pea 0|-16
               lda size
               clc
               adc #100
               pha
               pei listHndl+2
               pei listHndl
               _SetHandleSize           ;Now it is big enough.

bigEnough      pei listHndl+2           ;Dereference to list element.
               pei listHndl
               lda numEntries
               dec a
               pha
               jsr indexIntoListHndl
               sta listPtr
               stx listPtr+2

               ldy #omemPtr             ;Save data into list.
               lda amount
               sta [listPtr],y
               ldy #omemFlag
               lda #0
               sta [listPtr],y

               PushLong theWindow       ;Result space is normally needed
               ldx #4                   ;for this call.  The result will be
               lda playerNum            ;placed in the local variable theHndl.
               bne ad
               dex
ad             phx
               pea 0
               _GetCtlHandleFromID      ;Result is in theHndl.

               PushLong #drawListItem
               pei topOfList
               pei listHndl+2
               pei listHndl
               pea refIsHandle
               pei numEntries
               pei theHndl+2
               pei theHndl
               _NewList2                ;Tell the world about the list update.

               tsc                      ;Remove local variable space.
               clc
               adc #sizeLocals
               tcs
               pld                      ;Restore directPage register.
               plx                      ;Save return address.
               pla                      ;Remove passed parameters.
               pla
               phx                      ;Restore return address and return.
               rts

               end



indexIntoListHndl start

               DefineStack

saveDPage      word
returnAddr     word

index          word
listHndl       long

               phd                      ;Save directPage register.
               tsc
               tcd

               ldy #2
               lda [listHndl],y
               tax
               lda index
               asl a
               adc index
               asl a
               adc [listHndl]
               bcc aa
               inx

aa             ldy returnAddr           ;Move return address.
               sty listHndl+2
               pld                      ;Restore directPage register.
               ply                      ;Remove passed parameters
               ply
               ply
               rts

               end

***********************************************************************
*
* fixButtonTitle
*
* This routine is called only when the chosen game is crickett.  Its job
* is to adjust the button title of the button associated with the amount
* passed.
*
* There are four possible states of the button title.  Which state it is
* in depends on the number times it has been pressed (contained in the
* CrickettTables).
*
fixButtonTitle start

               DefineStack

theHndl        long                     ;Must be at 1,s

saveDPage      word
returnAddr     word

amount         word
playerNum      word

******************

               phd                      ;Save directPage register.
               pha
               pha                      ;Make space for locals.
               tsc                      ;Set directPage register.
               tcd

               lda amount               ;Figure the correct ID.
               ldx playerNum
               cpx #Player1
               beq aa
               ora #$8000
aa             ldx theWindow+2          ;theHndl will act as the result space.
               phx
               ldx theWindow
               phx
               pea 0|-16
               pha
               _GetCtlHandleFromID      ;Result now in theHndl.

               pei playerNum            ;Get crickettTables hit value.
               pei amount
               jsr getCTval
               cmp #4
               bcs noChange

               pea titleTbl|-16         ;Point to a title string.
               asl a                    ;There can't be a carry, since
               adc #titleTbl            ;we are pointing into a code bank.
               pha
               pei theHndl+2
               pei theHndl
               _SetCtlTitle

noChange       anop
               pla                      ;Remove local variable space.
               pla
               pld                      ;Restore directPage register.
               plx                      ;Save return address.
               pla                      ;Remove passed parameters.
               pla
               phx                      ;Restore return address and return.
               rts

titleTbl       dc i1'1'
               dc c' '
               dc i1'1'
               dc c'/'
               dc i1'1'
               dc c'X'
               dc i1'1'
               dc c'*'

               end

***********************************************************************
*
* removeSelected
*
* Removes any selected scores from the list.
*
removeSelected start

               DefineStack

theHndl        long                     ;Must be at 1,s
itemToRemove   word
amount         word
topOfList      word
size           word
listHndl       long
listPtr        long

sizeLocals     EndLocals

saveDPage      word
returnAddr     word

playerNum      word

******************

               phd                      ;Save directPage register.
               tsc
               sec
               sbc #sizeLocals
               tcs
               tcd                      ;Set directPage register.

               PushLong theWindow
               ldx #4                   ;theHndl will act as result space.
               lda playerNum
               bne aa
               dex
aa             phx
               pea 0
               _GetCtlHandleFromID      ;Result now in theHndl.

loopAway       pha                      ;Delete as many as are selected.
               pea 0
               pei theHndl+2
               pei theHndl
               _NextMember2
               pla
               sta itemToRemove
               bne ab
               brl inval

ab             lda playerNum
               asl a
               asl a
               tay
               lda scoreList+2,y
               sta listHndl+2
               pha
               lda scoreList,y
               sta listHndl
               pha
               lda itemToRemove
               dec a
               pha
               jsr indexIntoListHndl
               sta listPtr
               stx listPtr+2            ;We are pointing at the one to go.

               lda [listPtr]            ;This is how many points it is.
               sta amount

               lda gameType
               bne crickett
               lda playerNum            ;Simple subtract for Robin game.
               asl a
               tax
               lda score,x
               sec
               sbc amount
               sta score,x
               bra eitherGame

crickett       pei playerNum            ;Complicated subtract for crickett.
               pei amount
               jsr getCTval
               cmp #4
               bcc noSubtract
               lda playerNum
               asl a
               tax
               lda score,x
               sec
               sbc amount
               sta score,x
noSubtract     tyx                      ;YREG calculated by getCTval
               dec crickettTables,x
               pei playerNum
               pei amount
               jsr fixButtonTitle

eitherGame     pei listHndl+2           ;Re-dereference -- might have moved.
               pei listHndl
               lda itemToRemove
               dec a
               pha
               jsr indexIntoListHndl
               sta listPtr
               stx listPtr+2

               lda playerNum
               asl a
               tax
               lda listEntries,x
               dec listEntries,x        ;We will have 1 fewer soon.
               sec
               sbc itemToRemove
               sta size
               asl a
               adc size
               asl a
               sta size

               lda listPtr              ;Do a BlockMove to delete it.
               ldx listPtr+2
               clc
               adc #6
               bcc ac
               inx
ac             phx
               pha
               pei listPtr+2
               pei listPtr
               pea 0|-16
               pei size
               _BlockMove

               pha
               pei theHndl+2
               pei theHndl
               _GetCtlValue
               pla
               dec a
               bmi fixit
               bne ok
fixit          lda #1
ok             sta topOfList

               PushLong #drawListItem
               pei topOfList
               pei listHndl+2
               pei listHndl
               pea refIsHandle
               lda playerNum
               asl a
               tax
               lda listEntries,x
               pha
               pei theHndl+2
               pei theHndl
               _NewList2                ;Let the tools know something changed.

               brl loopAway

inval          pei playerNum            ;Update score on screen.
               jsr invalScore

               tsc                      ;Remove local variable space.
               clc
               adc #sizeLocals
               tcs
               pld                      ;Restore directPage register.
               plx                      ;Save return address.
               pla                      ;Remove passed parameters.
               phx                      ;Restore return address and return.
               rts

               end

***********************************************************************
*
* clearList
*
* Clears the indicated list.  
*
clearList      start

               DefineStack

theHndl        long                     ;Must be at 1,s

saveDPage      word
returnAddr     word

playerNum      word

******************

               phd                      ;Save directPage register.
               pha                      ;Make space for locals.
               pha
               tsc                      ;Set directPage register.
               tcd

               PushLong theWindow
               ldx #4
               lda playerNum
               bne aa
               dex
aa             phx
               pea 0
               _GetCtlHandleFromID

               lda playerNum
               asl a
               tax
               lda #0
               sta listEntries,x

               PushLong #drawListItem
               pea 0                    ;Item to display
               txa
               asl a
               tax
               lda scoreList+2,x
               pha
               lda scoreList,x
               pha
               pea refIsHandle
               pea 0                    ;Number of items
               pei theHndl+2
               pei theHndl
               _NewList2

               pla                      ;Remove local variable space.
               pla
               pld                      ;Restore directPage register.
               plx                      ;Save return address.
               pla                      ;Remove passed parameters.
               phx                      ;Restore return address and return.
               rts

               end

***********************************************************************
*
* startUpRobinGame
*
* Opens the robin game window and zeros the scores.
*
startupRobinGame start

               pha
               pha
               PushLong #0
               PushLong #0
               PushLong #drawThisWindow
               PushLong #0
               pea refIsResource
               PushLong #RobinWindow
               pea rWindParam1
               _NewWindow2
               pla
               sta theWindow
               pla
               sta theWindow+2

               lda #0
               sta listEntries
               sta listEntries+2

               rts

               end

***********************************************************************
*
* startupCrickettGame
*
* Opens the crickett game window and zeros the scores.
*
startupCrickettGame start

               pha
               pha
               PushLong #0
               PushLong #0
               PushLong #drawThisWindow
               PushLong #0
               pea refIsResource
               PushLong #CrickettWindow
               pea rWindParam1
               _NewWindow2
               pla
               sta theWindow
               pla
               sta theWindow+2

               lda #0
               sta listEntries
               sta listEntries+2
               sta weHaveAWinner

               rts

               end

***********************************************************************
*
* setupWindows
*
* Inits any of the window unit variables we need to start up 
* the game.  Calls the routine that opens the first window.
*
setupWindows   start

               ldy #4
loop           phy
               pha
               pha
               PushLong #500
               lda userID
               pha
               pea 0
               PushLong #0
               _NewHandle
               pla
               plx
               ply
               sta scoreList,y
               txa
               sta scoreList+2,y
               dey
               dey
               dey
               dey
               bpl loop

               lda #0
               sta firstUpdateComplete
               sta listEntries
               sta listEntries+2

               jsr startupRobinGame
               rts

               end

               END
